/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.mojang.authlib.GameProfile;
import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockVine;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketScoreboardObjective;
import net.minecraft.network.play.server.SPacketUpdateScore;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import nikedemos.markovnames.generators.MarkovAncientGreek;
import nikedemos.markovnames.generators.MarkovAztec;
import nikedemos.markovnames.generators.MarkovCustomNPCsClassic;
import nikedemos.markovnames.generators.MarkovGenerator;
import nikedemos.markovnames.generators.MarkovJapanese;
import nikedemos.markovnames.generators.MarkovOldNorse;
import nikedemos.markovnames.generators.MarkovRoman;
import nikedemos.markovnames.generators.MarkovSaami;
import nikedemos.markovnames.generators.MarkovSlavic;
import nikedemos.markovnames.generators.MarkovSpanish;
import nikedemos.markovnames.generators.MarkovWelsh;
import noppes.npcs.AbilityEventHandler;
import noppes.npcs.CommonProxy;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.CustomRegisters;
import noppes.npcs.LogWriter;
import noppes.npcs.PlayerEventHandler;
import noppes.npcs.ScriptItemEventHandler;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.ServerTickHandler;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.event.potion.AffectEntity;
import noppes.npcs.api.event.potion.EndEffect;
import noppes.npcs.api.event.potion.IsReadyEvent;
import noppes.npcs.api.event.potion.PerformEffect;
import noppes.npcs.api.handler.capability.IItemStackWrapperHandler;
import noppes.npcs.api.handler.capability.IMarkDataHandler;
import noppes.npcs.api.handler.capability.IPlayerDataHandler;
import noppes.npcs.api.handler.capability.IWrapperEntityDataHandler;
import noppes.npcs.api.wrapper.DataObject;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.WrapperEntityData;
import noppes.npcs.api.wrapper.WrapperNpcAPI;
import noppes.npcs.capability.ItemStackWrapperStorage;
import noppes.npcs.capability.MarkDataStorage;
import noppes.npcs.capability.PlayerDataStorage;
import noppes.npcs.capability.WrapperEntityDataStorage;
import noppes.npcs.command.CommandNoppes;
import noppes.npcs.config.ConfigLoader;
import noppes.npcs.config.ConfigProp;
import noppes.npcs.controllers.AnimationController;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.BorderController;
import noppes.npcs.controllers.ChunkController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.DropController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.GlobalDataController;
import noppes.npcs.controllers.KeyController;
import noppes.npcs.controllers.LinkedNpcController;
import noppes.npcs.controllers.MarcetController;
import noppes.npcs.controllers.MassBlockController;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerSkinController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.VisibilityController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.dimensions.CustomWorldProvider;
import noppes.npcs.dimensions.DimensionHandler;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.ItemScripted;
import noppes.npcs.reflection.entity.ai.attributes.RangedAttributeReflection;
import noppes.npcs.util.DataDebug;
import noppes.npcs.util.Util;

@Mod(modid="customnpcs", name="CustomNpcs", version="2.4", acceptedMinecraftVersions="1.12, 1.12.1, 1.12.2", guiFactory="noppes.npcs.config.CustomNpcsGuiFactory")
public class CustomNpcs {
    @ConfigProp(info="Currency symbol displayed in stores (unicode)", def="20AC")
    public static String CharCurrencies = "20AC";
    public static String displayCurrencies = "\u20ac";
    @ConfigProp(info="Number of chunk loading npcs that can be active at the same time", def="20")
    public static int ChuckLoaders = 20;
    @ConfigProp(info="Minimum and maximum melle and range Damage of NPCs for 1 and Maximum level, respectively (rarity Boss)", def="8,52,6,26", min="0,0,0,0")
    public static int[] DamageBoss = new int[]{8, 52, 6, 26};
    @ConfigProp(info="Minimum and maximum melle and range Damage of NPCs for 1 and Maximum level, respectively (rarity Elite)", def="6,32,3,16", min="0,0,0,0")
    public static int[] DamageElite = new int[]{6, 32, 3, 16};
    @ConfigProp(info="Minimum and maximum melle and range Damage of NPCs for 1 and Maximum level, respectively (rarity Normal)", def="4,22,2,11", min="0,0,0,0")
    public static int[] DamageNormal = new int[]{4, 22, 2, 11};
    @ConfigProp(info="Default interact line. Leave empty to not have one", def="Hello @p")
    public static String DefaultInteractLine = "Hello @p";
    @ConfigProp(info="If you are running sponge and you want to disable the permissions set this to true", def="false")
    public static boolean DisablePermissions = false;
    @ConfigProp(info="Enable Chat Bubbles from npcs", def="true")
    public static boolean EnableChatBubbles = true;
    @ConfigProp(info="Enable chat bubbles from players", def="true")
    public static boolean EnablePlayerChatBubbles = true;
    @ConfigProp(info="For some it works, for others it doesnt, so Im disabling by default", def="false")
    public static boolean EnableInvisibleNpcs = false;
    @ConfigProp(info="Whether scripting is enabled or not", def="true")
    public static boolean EnableScripting = true;
    @ConfigProp(info="Are scripts enabled for Forge events or not", def="true")
    public static boolean EnableForgeScripting = true;
    @ConfigProp(info="Script password. Necessary for decrypting scripts", def="00bb7f7647ca389196fe03177d2fac78")
    public static String ScriptPassword = UUID.randomUUID().toString().replace("-", "");
    @ConfigProp(info="Enables CustomNpcs startup update message", def="true")
    public static boolean EnableUpdateChecker = true;
    @ConfigProp(info="Maximum and minimum amount of experience dropped from the NPC for the minimum and maximum level (Elite x1.75; Boss x4.75)", def="2,3,100,115", min="0,0,0,0")
    public static int[] Experience = new int[]{2, 3, 100, 115};
    @ConfigProp(info="Font size for custom fonts (doesn't work with minecraft fonts)", def="18", min="6", max="36")
    public static int FontSize = 18;
    @ConfigProp(info="Main text color of elements in GUI modification", def="FFFFFF")
    public static Color MainColor = new Color(-1);
    @ConfigProp(info="Name text color in GUI modification", def="404040")
    public static Color LableColor = new Color(-12566464);
    @ConfigProp(info="Text color for inactive elements in modification GUI", def="A0A0A0")
    public static Color NotEnableColor = new Color(-6250336);
    @ConfigProp(info="Text color of elements in modification GUI when the element is held down by the mouse cursor", def="FFFFA0")
    public static Color HoverColor = new Color(-96);
    @ConfigProp(info="Text Color for GUI Quest Log", def="404060")
    public static Color QuestLogColor = new Color(-12566432);
    @ConfigProp(info="Color of message bubbles above NPC head [text, frame, base]", def="000000,000000,FFFFFF")
    public static Color[] ChatNpcColors = new Color[]{new Color(-16777216), new Color(-16777216), new Color(-1)};
    @ConfigProp(info="Color of message bubbles above Player head [text, frame, base]", def="000000,2C4C00,E0FFB0")
    public static Color[] ChatPlayerColors = new Color[]{new Color(-16777216), new Color(-13874176), new Color(-2031696)};
    @ConfigProp(info="Font for writing scripts. When set to \"Minecraft\" it will use minecraft fonts, when \"Default\" it will use \"JetBrainsMono\". Can only use fonts installed on <you game dir>/customnpcs/assets/customnpcs/fonts/*.ttf", def="Default")
    public static String FontType = "Default";
    @ConfigProp(info="Type 0=Normal; 1=Solid; 2=Not show", def="1", min="0", max="1")
    public static int HeadWearType = 1;
    @ConfigProp(info="Minimum and maximum health of NPCs for 1 and Maximum level, respectively (rarity Boss)", def="250,20000", min="1,1")
    public static int[] HealthBoss = new int[]{250, 20000};
    @ConfigProp(info="Minimum and maximum health of NPCs for 1 and Maximum level, respectively (rarity Elite)", def="60,1200", min="1,1")
    public static int[] HealthElite = new int[]{60, 1200};
    @ConfigProp(info="Minimum and maximum health of NPCs for 1 and Maximum level, respectively (rarity Normal)", def="20,500", min="1,1")
    public static int[] HealthNormal = new int[]{20, 500};
    @ConfigProp(info="Enables Ice Melting", def="true")
    public static boolean IceMeltsEnabled = true;
    @ConfigProp(info="Enables leaves decay", def="true")
    public static boolean LeavesDecayEnabled = true;
    @ConfigProp(info="Maximum NPC level", def="45", min="1", max="10000")
    public static int MaxLv = 45;
    @ConfigProp(info="Resizes the model for rarity. (Normal, Elite, Boss)", def="5,6,7", min="1,2,3")
    public static int[] ModelRaritySize = new int[]{5, 6, 7};
    @ConfigProp(info="Arguments given to the Nashorn scripting library", def="-strict")
    public static String NashornArguments = "-strict";
    @ConfigProp(info="Navigation search range for NPCs. Not recommended to increase if you have a slow pc or on a server", def="32", min="16", max="64")
    public static int NpcNavRange = 32;
    @ConfigProp(info="Set to true if you want the dialog command option to be able to use op commands like tp etc", def="false")
    public static boolean NpcUseOpCommands = false;
    @ConfigProp(info="Only ops can create and edit npcs", def="false")
    public static boolean OpsOnly = false;
    @ConfigProp(info="Whether to recalculate Stats when setting Level and Rarity", def="true")
    public static boolean RecalculateLR = true;
    @ConfigProp(info="Parameters for calculating NPC Resistances (0=-100%, 1=0%, 2=100% [melee, arrow, explosion, knockback] rarity Boss)", def="110,125,175,195", min="0,0,0,0", max="200,200,200,200")
    public static int[] ResistanceBoss = new int[]{110, 125, 175, 195};
    @ConfigProp(info="Parameters for calculating NPC Resistances (0=-100%, 1=0%, 2=100% [melee, arrow, explosion, knockback] rarity Elite)", def="105,110,130,150", min="0,0,0,0", max="200,200,200,200")
    public static int[] ResistanceElite = new int[]{105, 110, 130, 150};
    @ConfigProp(info="Parameters for calculating NPC Resistances (0=-100%, 1=0%, 2=100% [melee, arrow, explosion, knockback] rarity Normal)", def="100,100,100,100", min="0,0,0,0", max="200,200,200,200")
    public static int[] ResistanceNormal = new int[]{100, 100, 100, 110};
    @ConfigProp(info="Whether to display Level and Rarity. If 1 then it will be installed on all clients", def="true")
    public static boolean ShowLR = true;
    @ConfigProp(info="Display player balance in inventory", def="true")
    public static boolean ShowMoney = true;
    @ConfigProp(info="Display player Quest Compass", def="true")
    public static boolean ShowQuestCompass = false;
    @ConfigProp(info="Display hitbox of nearby NPCs when holding mod tools", def="true")
    public static boolean ShowHitboxWhenHoldTools = true;
    @ConfigProp(info="Normal players can use soulstone on animals", def="true")
    public static boolean SoulStoneAnimals = true;
    @ConfigProp(info="Normal players can use soulstone on all npcs", def="false")
    public static boolean SoulStoneNPCs = false;
    @ConfigProp(info="Show description when hovering cursor on over GUI elements", def="true", type="client")
    public static boolean ShowDescriptions = true;
    @ConfigProp(info="Show Debug", def="false")
    public static boolean VerboseDebug = false;
    @ConfigProp(info="Enables Vine Growth", def="true")
    public static boolean VineGrowthEnabled = true;
    @ConfigProp(info="Displaying mod toolbox hitboxes in the world", def="true")
    public static boolean ShowHitboxBlockTools = true;
    @ConfigProp(info="Maximum blocks to install per second with the Builder item", def="10000", min="100", max="100000000")
    public static int MaxBuilderBlocks = 10000;
    @ConfigProp(info="Maximum number of items in one Drop group", def="32", min="1", max="64")
    public static int MaxItemInDropsNPC = 32;
    @ConfigProp(info="Cancel the creation of variables in each Forge event (saves FPS)", def="false")
    public static boolean SceneButtonsEnabled = true;
    @ConfigProp(info="NPC speech can trigger a chat event", def="false")
    public static boolean NpcSpeachTriggersChatEvent = false;
    @ConfigProp(info="Show faction, quest and compass tabs in player inventory", def="true")
    public static boolean InventoryGuiEnabled = true;
    @ConfigProp(info="Summon a new NPC with random custom eyes", def="true")
    public static boolean EnableDefaultEyes = true;
    @ConfigProp(info="Time in real days when the letter will be deleted from the player (-1 = never, at least 1 day, max 60)", def="30")
    public static int MailTimeWhenLettersWillBeDeleted = 30;
    @ConfigProp(info="Time in seconds when a player can receive a letter [min not less than 10, max not more than 3600]", def="120,300", min="10,10", max="3600,3600")
    public static int[] MailTimeWhenLettersWillBeReceived = new int[]{120, 300};
    @ConfigProp(info="Cost for sending a letter in game currency. [base send, one page, one stack of item, percentage of currency, redemption percentage]", def="10,5,30,2,4", min="0,0,0,0,0")
    public static int[] MailCostSendingLetter = new int[]{10, 5, 30, 2, 4};
    @ConfigProp(info="Can players send themselves letters?", def="false")
    public static boolean MailSendToYourself = false;
    @ConfigProp(info="Position on the screen of the icon indicating the presence of new messages (-1 = do not show, then from 0 to 3)", def="1", min="-1", max="3")
    public static int MailWindow = 1;
    @ConfigProp(info="Maximum number of tabs for scripts (from 1 to 20) Recommended: 5", def="10", min="1", max="20")
    public static int ScriptMaxTabs = 10;
    @ConfigProp(info="The speed for dialogs that show individual letters. (number per second from 10 to 100)", def="30", min="10", max="100", type="client")
    public static int DialogShowFitsSpeed = 30;
    @ConfigProp(info="When a player's dimension changes, their home position will change to portal position", def="true")
    public static boolean SetPlayerHomeWhenChangingDimension = true;
    @ConfigProp(info="Displaying joints on an NPC model", def="true", type="client")
    public static boolean ShowJoints = true;
    @ConfigProp(info="Display custom NPC animations. Disable it if you have a weak computer", def="true")
    public static boolean ShowCustomAnimation = true;
    @ConfigProp(info="Send a message to the player's chat about a completed transaction", def="false", type="client")
    public static boolean SendMarcetInfo = false;
    @ConfigProp(info="Percentage of knockback power of all entities in the game when dealing damage or blocking", def="100", min="0", max="200")
    public static int KnockBackBasePower = 100;
    @ConfigProp(info="Shows the rarity of the item in the inventory slot", def="true", type="client")
    public static boolean ShowRarityItem = true;
    @ConfigProp(info="Percentage of knockback power of all entities in the game when dealing damage or blocking", def="10", min="0", max="100")
    public static int DefaultHurtResistantTime = 10;
    @ConfigProp(info="When NPCs self-heal, particles will appear above their heads", def="true")
    public static boolean ShowHealingParticles = true;
    @ConfigProp(info="To display script errors in chat or not", def="true", type="client")
    public static boolean DisplayErrorInChat = true;
    @ConfigProp(info="Show additional buttons in the GUI menu or not", def="false", type="client")
    public static boolean ShowButtonsInGuiMenu = false;
    @SidedProxy(clientSide="noppes.npcs.client.ClientProxy", serverSide="noppes.npcs.CommonProxy")
    public static CommonProxy proxy;
    public static final String MODID = "customnpcs";
    public static final String MODNAME = "CustomNpcs";
    public static FMLEventChannel Channel;
    public static FMLEventChannel ChannelPlayer;
    public static CustomNpcs instance;
    public static CommandNoppes NoppesCommand;
    public static MarkovGenerator[] MARKOV_GENERATOR;
    public static MinecraftServer Server;
    public static boolean DebugMonitoring;
    public static DataDebug debugData;
    public static boolean FreezeNPCs;
    public static boolean showServerQuestCompass;
    public static File Dir;
    public static ConfigLoader Config;
    public static ITextComponent prefix;
    public static DimensionType customDimensionType;
    public static ModContainer mod;
    public static final VisibilityController visibilityController;
    public static int colorAnimHoverPart;
    public static int PanoramaNumbers;

    public static File getWorldSaveDirectory() {
        return CustomNpcs.getWorldSaveDirectory(null);
    }

    public static File getWorldSaveDirectory(String s) {
        try {
            File dir = new File(".");
            if (Server != null) {
                if (!Server.func_71262_S()) {
                    dir = new File(Minecraft.func_71410_x().field_71412_D, "saves");
                }
                dir = new File(new File(dir, Server.func_71270_I()), MODID);
            }
            if (s != null) {
                dir = new File(dir, s);
            }
            if (dir.exists() || dir.mkdirs()) {
                return dir;
            }
            return null;
        }
        catch (Exception e) {
            LogWriter.error("Error getting world save", e);
            return null;
        }
    }

    @Mod.EventHandler
    public static void postload(FMLPostInitializationEvent ev) {
        new Util();
        for (ModContainer mod : Loader.instance().getModList()) {
            if (!mod.getModId().equals(MODID)) continue;
            CustomNpcs.mod = mod;
        }
        ScriptController.forgeClientEventNames.put(IsReadyEvent.class, "customPotionIsReady");
        ScriptController.forgeClientEventNames.put(PerformEffect.class, "customPotionPerformEffect");
        ScriptController.forgeClientEventNames.put(AffectEntity.class, "customPotionAffectEntity");
        ScriptController.forgeClientEventNames.put(EndEffect.class, "customPotionEndEffect");
        proxy.postload();
        LogWriter.info("Mod loaded ^_^ Have a good game!");
    }

    public CustomNpcs() {
        instance = this;
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent ev) {
        PixelmonHelper.load();
        ScriptController controller = new ScriptController();
        if (EnableScripting && !controller.languages.isEmpty()) {
            MinecraftForge.EVENT_BUS.register((Object)controller);
            MinecraftForge.EVENT_BUS.register((Object)new PlayerEventHandler().registerForgeEvents(ev.getSide()));
            MinecraftForge.EVENT_BUS.register((Object)new ScriptItemEventHandler());
        }
        ForgeModContainer.fullBoundingBoxLadders = true;
        new CustomNpcsPermissions();
        new RecipeController();
        CustomNpcs.MARKOV_GENERATOR[0] = new MarkovRoman(3);
        CustomNpcs.MARKOV_GENERATOR[1] = new MarkovJapanese(4);
        CustomNpcs.MARKOV_GENERATOR[2] = new MarkovSlavic(3);
        CustomNpcs.MARKOV_GENERATOR[3] = new MarkovWelsh(3);
        CustomNpcs.MARKOV_GENERATOR[4] = new MarkovSaami(3);
        CustomNpcs.MARKOV_GENERATOR[5] = new MarkovOldNorse(4);
        CustomNpcs.MARKOV_GENERATOR[6] = new MarkovAncientGreek(3);
        CustomNpcs.MARKOV_GENERATOR[7] = new MarkovAztec(3);
        CustomNpcs.MARKOV_GENERATOR[8] = new MarkovCustomNPCsClassic(3);
        CustomNpcs.MARKOV_GENERATOR[9] = new MarkovSpanish(3);
        proxy.load();
    }

    @Mod.EventHandler
    public void preload(FMLPreInitializationEvent ev) {
        Channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(MODNAME);
        ChannelPlayer = NetworkRegistry.INSTANCE.newEventDrivenChannel("CNPCsPlayer");
        Dir = new File(new File(ev.getModConfigurationDirectory(), ".."), MODID);
        if (!Dir.exists() && !Dir.mkdir()) {
            throw new RuntimeException("Impossible error: Failed to create sections important for the CustomNpcs mod!");
        }
        Config = new ConfigLoader(ev.getModConfigurationDirectory());
        if (NpcNavRange < 16) {
            NpcNavRange = 16;
        }
        CustomRegisters.load();
        CapabilityManager.INSTANCE.register(IPlayerDataHandler.class, (Capability.IStorage)new PlayerDataStorage(), PlayerData::new);
        CapabilityManager.INSTANCE.register(IMarkDataHandler.class, (Capability.IStorage)new MarkDataStorage(), MarkData::new);
        CapabilityManager.INSTANCE.register(IWrapperEntityDataHandler.class, (Capability.IStorage)new WrapperEntityDataStorage(), WrapperEntityData::new);
        CapabilityManager.INSTANCE.register(IItemStackWrapperHandler.class, (Capability.IStorage)new ItemStackWrapperStorage(), ItemStackWrapper::new);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        MinecraftForge.EVENT_BUS.register((Object)new ServerEventsHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ServerTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        Objects.requireNonNull(NpcAPI.Instance()).events().register((Object)new AbilityEventHandler());
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ChunkController());
        customDimensionType = DimensionType.register((String)"CustomDimensions", (String)MODNAME, (int)"CustomDimensions".hashCode(), CustomWorldProvider.class, (boolean)false);
        proxy.preload();
        RangedAttributeReflection.setMaxValue((RangedAttribute)SharedMonsterAttributes.field_111267_a, Double.MAX_VALUE);
        DataObject.load();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        LogWriter.info("Mod starting");
        event.registerServerCommand((ICommand)NoppesCommand);
        EntityNPCInterface.ChatEventPlayer = new FakePlayer(event.getServer().func_71218_a(0), (GameProfile)EntityNPCInterface.ChatEventProfile);
        EntityNPCInterface.CommandPlayer = new FakePlayer(event.getServer().func_71218_a(0), (GameProfile)EntityNPCInterface.CommandProfile);
        EntityNPCInterface.GenericPlayer = new FakePlayer(event.getServer().func_71218_a(0), (GameProfile)EntityNPCInterface.GenericProfile);
        for (WorldServer world : CustomNpcs.Server.field_71305_c) {
            ServerScoreboard board = (ServerScoreboard)world.func_96441_U();
            board.func_186684_a(() -> {
                for (String s : Availability.scores) {
                    ScoreObjective so = board.func_96518_b(s);
                    if (so == null) continue;
                    for (EntityPlayerMP player : Server.func_184103_al().func_181057_v()) {
                        if (!board.func_178819_b(player.func_70005_c_(), so) && board.func_96552_h(so) == 0) {
                            player.field_71135_a.func_147359_a((Packet)new SPacketScoreboardObjective(so, 0));
                        }
                        player.field_71135_a.func_147359_a((Packet)new SPacketUpdateScore(board.func_96529_a(player.func_70005_c_(), so)));
                    }
                }
            });
            board.func_186684_a(() -> {
                for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                    if (PlayerData.get((EntityPlayer)player) == null) continue;
                    visibilityController.onUpdate(player);
                }
            });
        }
        DimensionHandler.getInstance().loadDimensions();
    }

    @Mod.EventHandler
    public void setAboutToStart(FMLServerAboutToStartEvent event) {
        LogWriter.info("Load map_world datas");
        Server = event.getServer();
        ChunkController.instance.clear();
        FactionController.instance.load();
        ScriptController.Instance.load();
        DropController.getInstance().loadFile();
        AnimationController.getInstance().loadAnimations();
        new KeyController();
        new TransportController();
        new PlayerDataController();
        new GlobalDataController();
        new SpawnController();
        new LinkedNpcController();
        new MassBlockController();
        new PlayerSkinController();
        WrapperNpcAPI.clearCache();
        Set names = Block.field_149771_c.func_148742_b();
        for (ResourceLocation name : names) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)name);
            if (block instanceof BlockLeaves) {
                block.func_149675_a(LeavesDecayEnabled);
            }
            if (block instanceof BlockVine) {
                block.func_149675_a(VineGrowthEnabled);
            }
            if (!(block instanceof BlockIce)) continue;
            block.func_149675_a(IceMeltsEnabled);
        }
        File level = new File(CustomNpcs.getWorldSaveDirectory().getParentFile(), "level.dat");
        if (level.exists()) {
            try {
                NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(level.toPath(), new OpenOption[0]));
                NBTTagList list = nbt.func_74775_l("FML").func_74775_l("Registries").func_74775_l("minecraft:entities").func_150295_c("ids", 10);
                NBTTagList newList = new NBTTagList();
                boolean resave = false;
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    String name = list.func_150305_b(i).func_74779_i("K");
                    if (name.indexOf("minecraft:customnpcs.") == 0) {
                        resave = true;
                        continue;
                    }
                    newList.func_74742_a((NBTBase)list.func_150305_b(i));
                }
                if (resave) {
                    nbt.func_74775_l("FML").func_74775_l("Registries").func_74775_l("minecraft:entities").func_74782_a("ids", (NBTBase)newList);
                    CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)Files.newOutputStream(level.toPath(), new OpenOption[0]));
                }
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
    }

    @Mod.EventHandler
    public void started(FMLServerStartedEvent event) {
        if (Server != null) {
            CustomNpcs.debugData.started = System.currentTimeMillis();
            CustomNpcs.debugData.startedTicks = Server.func_71218_a(0).func_82737_E();
        }
        new BankController();
        new MarcetController();
        new BorderController();
        DialogController.instance.load();
        QuestController.instance.load();
        ScriptController.HasStart = true;
        ServerCloneController.Instance = new ServerCloneController();
        ScriptController.Instance.loadItemTextures();
    }

    @Mod.EventHandler
    public void stopped(FMLServerStoppedEvent event) {
        CustomNpcs.Config.config.save();
        ServerCloneController.Instance = null;
        PlayerSkinController.getInstance().save();
        MarcetController.getInstance().saveMarcets();
        AnimationController.getInstance().save();
        KeyController.getInstance().save();
        DropController.getInstance().save();
        ScriptController.Instance.saveItemTextures();
        ItemScripted.Resources.clear();
        BankController.getInstance().update();
        RecipeController.getInstance().checkSaves();
        Server = null;
    }

    public static void setCharCurrencies(String unicode) {
        CharCurrencies = unicode;
        try {
            displayCurrencies = "" + (char)Integer.parseInt(unicode, 16);
        }
        catch (Exception e) {
            displayCurrencies = "" + unicode.charAt(0);
        }
    }

    static {
        NoppesCommand = new CommandNoppes();
        MARKOV_GENERATOR = new MarkovGenerator[10];
        DebugMonitoring = false;
        debugData = new DataDebug();
        FreezeNPCs = false;
        showServerQuestCompass = true;
        prefix = new TextComponentString("\u00a7e[\u00a72CustomNpcs\u00a7e]\u00a7r: ");
        visibilityController = new VisibilityController();
        colorAnimHoverPart = new Color(-362496).getRGB();
        PanoramaNumbers = 4;
        FluidRegistry.enableUniversalBucket();
    }
}

